<?php
/*------------------------------------------------------------------------------
 customer.lang.inc.php 2023-02-21
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2023 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 -----------------------------------------------------------------------------*/

$t_language_text_section_content_array = [
    'overview_title'                                        => 'Customer Overview',
    'overview_add_customer'                                 => 'Add Customer',
    'overview_customer_group'                               => 'Customer Group',
    'overview_search_placeholder'                           => 'Search',
    'overview_settings'                                     => 'Settings',
    'overview_country'                                      => 'Country',
    'overview_city'                                         => 'City',
    'overview_is_favorite'                                  => 'Is Favorite',
    'overview_has_subscribed'                               => 'Has Subscribed',
    'overview_name'                                         => 'Name',
    'overview_email'                                        => 'Email',
    'overview_phone'                                        => 'Phone',
    'overview_company'                                      => 'Company',
    'overview_vat_number'                                   => 'VAT No.',
    'overview_vat_id_verified'                              => 'VAT ID verified',
    'overview_vat_id_not_verified'                          => 'VAT ID not verified',
    'overview_per_page'                                     => 'per page',
    'overview_page_prev'                                    => 'Previous page',
    'overview_page_next'                                    => 'Next page',
    'overview_page'                                         => 'Page',
    'overview_from'                                         => 'from',
    'overview_to'                                           => 'to',
    'overview_customers'                                    => 'customers',
    'overview_guest_account'                                => 'Guest Account',
    'overview_no_filter_selected'                           => 'No filter selected',
    'overview_no_results'                                   => 'No customers found',
    'overview_no_results_hint'                              => 'Try changing the filters/search conditions above.',
    'overview_filter_favorite'                              => 'Favorites',
    'overview_delete_guest_accounts'                        => 'Delete guest accounts',
    'overview_delete_guest_accounts_modal_body'             => 'Do you really want to delete all guest accounts?',
    'overview_delete_guest_accounts_deleted'                => 'All guest accounts were successfully deleted.',
    'overview_tooltip_customer_profile'                     => 'Open customer details',
    'overview_tooltip_customer_orders'                      => 'Open customer orders',
    'overview_tooltip_customer_favorite_add'                => 'Add to Favorites',
    'overview_tooltip_customer_favorite_remove'             => 'Remove from Favorites',
    'overview_tooltip_customer_email'                       => 'Write email to customer',
    'overview_registration_date'                            => 'Registration Date',
    'overview_last_login'                                   => 'Last Login',
    'overview_send_new_customer_password_email'             => 'Send email with password to customer?',
    'overview_send_new_customer_password_email_hint'        => 'After creating the customer you will be redirected to the email page in order to send the password.',
    'profile_back_to_overview'                              => 'Back to the Overview',
    'profile_title'                                         => 'Customer Profile',
    'profile_page_title'                                    => 'Profile',
    'profile_no_name'                                       => 'Unknown',
    'profile_not_found'                                     => 'Customer not found',
    'profile_not_found_description'                         => 'The customer with ID: {id} does not exit.',
    'profile_not_found_back_button'                         => 'All Customers',
    'profile_login_as_customer'                             => 'Login as customer',
    'profile_login_as_customer_modal_title'                 => 'Login as {customer}',
    'profile_login_as_customer_button'                      => 'Login',
    'profile_login_as_customer_warning'                     => 'Signing in as {customer} will break your current session.',
    'profile_login_as_customer_warning_preference'          => 'Don\'t show this message again',
    'profile_email'                                         => 'Email',
    'profile_new_order'                                     => 'New Order',
    'profile_memos'                                         => 'Notes',
    'profile_memos_loading'                                 => 'Loading',
    'profile_memos_empty'                                   => 'No notes added to this user',
    'profile_memos_creator'                                 => 'Me',
    'profile_memos_placeholder'                             => 'Leave a note',
    'profile_memos_add'                                     => 'Add Note',
    'profile_memos_cancel'                                  => 'Cancel',
    'profile_memos_delete'                                  => 'Delete Note',
    'profile_memos_delete_confirmation'                     => 'Are you sure you want to delete this note?',
    'profile_change_customer_group'                         => 'Change customer group',
    'profile_new_customer_group'                            => 'New Customer Group',
    'profile_current_customer_group'                        => 'Current',
    'profile_customer_group_hint'                           => 'Move this customer to an existing customer group or create a new one.',
    'profile_create_customer_group'                         => 'Create new customer group',
    'profile_customer_group'                                => 'Customer Group',
    'profile_customer_group_desc'                           => 'Assign {customer} to another customer group.',
    'profile_change_password'                               => 'Change Password',
    'profile_new_password'                                  => 'New Password',
    'profile_password'                                      => 'Password',
    'profile_password_show'                                 => 'Show password',
    'profile_password_hide'                                 => 'Hide password',
    'profile_password_generate'                             => 'Generate new password',
    'profile_salutation'                                    => 'Salutation',
    'profile_salutation_mr'                                 => 'Mr.',
    'profile_salutation_ms'                                 => 'Ms.',
    'profile_salutation_none'                               => 'None',
    'profile_first_name'                                    => 'First Name',
    'profile_last_name'                                     => 'Last Name',
    'profile_company_name'                                  => 'Company Name',
    'profile_street_name'                                   => 'Street Name',
    'profile_house_number'                                  => 'House Number',
    'profile_post_code'                                     => 'Post Code',
    'profile_city'                                          => 'City',
    'profile_country'                                       => 'Country',
    'profile_suburb'                                        => 'Suburb',
    'profile_state'                                         => 'State',
    'profile_additional_information'                        => 'Additional Information',
    'profile_vat_id'                                        => 'VAT ID',
    'profile_vat_id_verified'                               => 'VAT ID verified',
    'profile_vat_id_not_verified'                           => 'VAT ID not verified',
    'profile_tradeperson'                                   => 'Trade Person',
    'profile_disallowed_payment_methods'                    => 'Disallowed Payment Methods',
    'profile_disallowed_shipping_methods'                   => 'Disallowed Shipping Methods',
    'profile_logging'                                       => 'Logging',
    'profile_log_activity'                                  => 'Log Admin Activity',
    'profile_phone_number'                                  => 'Phone Number',
    'profile_fax_number'                                    => 'Fax Number',
    'profile_payment_address'                               => 'Payment Address',
    'profile_shipping_address'                              => 'Shipping Address',
    'profile_date_of_birth'                                 => 'Date Of Birth',
    'profile_customer_number'                               => 'Customer Number',
    'profile_business_information'                          => 'Business Information',
    'profile_configurations'                                => 'Configurations',
    'profile_contact_information'                           => 'Contact Information',
    'profile_address'                                       => 'Address',
    'profile_guest_account'                                 => 'Guest Account',
    'profile_gender'                                        => 'Gender',
    'profile_gender_m'                                      => 'Male',
    'profile_gender_f'                                      => 'Female',
    'profile_gender_d'                                      => 'Diverse',
    'profile_personal_information'                          => 'Personal Information',
    'profile_error_empty_first_name'                        => 'Please enter the first name',
    'profile_error_empty_last_name'                         => 'Please enter the last name',
    'profile_error_password'                                => 'Password must have at least {amount} characters',
    'profile_error_password_empty'                          => 'Please enter the password',
    'profile_delete_customer'                               => 'Delete customer account',
    'profile_edit'                                          => 'Edit',
    'profile_total_spent_to_date'                           => 'Total spent to date',
    'profile_loading'                                       => 'Loading',
    'profile_total_orders'                                  => 'Total orders',
    'profile_average_order_value'                           => 'Average order value',
    'profile_balance'                                       => 'Balance',
    'profile_balance_hint'                                  => 'Using the input fields, you can add balance to this customer account, e.g. as an incentive for additional purchases.',
    'profile_balance_edit'                                  => 'Edit Balance',
    'profile_balance_increment'                             => 'Increase balance by {amount}',
    'profile_balance_decrement'                             => 'Reduce balance by {amount}',
    'profile_add'                                           => 'Add',
    'profile_placed_order'                                  => 'Placed order <a href="{link}">{order}</a>',
    'profile_reviewed_product'                              => 'Reviewed <a href="{link}">{product}</a> with {rating} out of 5 stars',
    'profile_created_account'                               => 'Created the account',
    'profile_redeemed_voucher'                              => 'Redeemed voucher <a href="{voucherLink}">{voucherDescription}</a> on order <a href="{orderLink}">{orderId}</a>',
    'profile_added_product_to_cart'                         => 'Added product <a href="{link}">{product}</a> (Quantity: {quantity}) to cart',
    'profile_added_product_to_wishlist'                     => 'Added product <a href="{link}">{product}</a> (Quantity: {quantity}) to wishlist',
    'profile_subscribed_to_newsletter'                      => 'Signed up for receiving newsletters.',
    'profile_subscribed_to_newsletter_by_you'               => 'Signed up for receiving newsletters by you.',
    'profile_subscribed_to_newsletter_by_admin'             => 'Signed up for receiving newsletters by {admin}.',
    'profile_order'                                         => 'Order',
    'profile_order_view'                                    => 'Show',
    'profile_products'                                      => 'Product(s)',
    'profile_history'                                       => 'History',
    'profile_orders'                                        => 'Orders',
    'profile_wishlist'                                      => 'Wishlist',
    'profile_cart'                                          => 'Cart',
    'profile_reviews'                                       => 'Reviews',
    'profile_currency_format_locale'                        => 'en-UK',
    'profile_error_empty_email'                             => 'Please enter the email address',
    'profile_customer_deleted'                              => 'Customer has been deleted',
    'profile_product_number'                                => 'Product No.',
    'profile_empty_wishlist'                                => 'Empty Wishlist',
    'profile_empty_cart'                                    => 'Empty Cart',
    'profile_empty_state_cart'                              => '{customer} cart is empty.',
    'profile_empty_state_reviews'                           => '{customer} has not submitted any reviews yet.',
    'profile_empty_state_wishlist'                          => '{customer} wishlist is empty.',
    'profile_empty_state_orders'                            => '{customer} has not placed any orders yet.',
    'modal_save'                                            => 'Save',
    'modal_cancel'                                          => 'Cancel',
    'modal_close'                                           => 'Close',
    'modal_delete'                                          => 'Delete',
    'modal_next'                                            => 'Next',
    'modal_create_customer'                                 => 'Create Customer',
    'modal_create_customer_title'                           => 'Create New Customer',
    'modal_delete_customer'                                 => 'Delete customer account',
    'modal_delete_customer_text'                            => 'The following data from {customer} will be permanently deleted:',
    'modal_delete_customer_deleted_data_text'               => 'The following personal data can additionally be deleted:',
    'modal_delete_customer_switch'                          => 'Only delete data?',
    'modal_delete_customer_action_label'                    => 'Delete account',
    'modal_delete_customer_personal_data_gobd_warning_text' => 'Certain legal retention periods apply for customer data, orders, etc. Please make sure that you observe them.',
    'create_customer_password_email_subject'                => 'Your {shop_url} account',
    'create_customer_password_email_body'                   => 'Hello {firstname} {lastname},<br />
<br />
we created an account for our shop for you.<br />
<br />
You can log in <a href="{shop_url}/login.php">here</a> using this email and the following password:<br />
<br />
{password}',
    'profile_export_personal_data'                          => 'Export personal data',
    'profile_delete_personal_data'                          => 'Delete personal data',
    'profile_delete_personal_data_text'                     => 'Data from {customer} that will be permanently deleted:',
    'profile_delete_personal_data_account_text'             => 'The customer account and the following data will not be deleted:',
    'profile_delete_personal_data_switch'                   => 'Delete customer account?',
    'profile_delete_personal_data_action_label'             => 'Delete data',
    'profile_select_all'                                    => 'Select all',
    'profile_select_personal_data_base_data'                => 'Profile data incl. addresses',
    'profile_select_personal_data_shopping_cart_wishlist'   => 'Shopping cart and wishlist',
    'profile_select_personal_data_wishlist'                 => 'Wishlist',
    'profile_select_personal_data_balance'                  => 'Balance',
    'profile_select_personal_data_orders'                   => 'Orders, invoices and delivery notes',
    'profile_select_personal_data_withdrawals'              => 'Withdrawals',
    'profile_select_personal_data_agreements'               => 'Agreements',
    'profile_select_personal_data_emails'                   => 'Emails',
    'profile_select_personal_data_carts'                    => 'Shopping cart',
    'profile_select_personal_data_reviews'                  => 'Reviews',
    'profile_select_personal_data_newsletter_subscriptions' => 'Newsletter subscriptions',
    'error_heading'                                         => 'Please note',
    'error_message'                                         => 'The changes could not be saved.',
    'profile_disallowed_payment_methods_hint'               => 'Hint: Comma-separated in case of multiple payment methods (e. g. "invoice, cod")',
    'profile_disallowed_shipping_methods_hint'              => 'Hint: Comma-separated in case of multiple shipping methods (e. g. "flat, freeamount")',
    'profile_newsletter_subscription_badge'                 => 'Subscribed',
    'profile_newsletter_subscription_label'                 => 'Newsletter Subscription',
    'profile_newsletter_subscription_option'                => 'Subscribed',
    'profile_newsletter_subscription_warning'               => '<strong>Important:</strong> Subscribing customers to the newsletter without explicit consent might lead to legal issues.',
    'profile_favorite_customer'                             => 'Favorite Customer',
    'profile_favorite_customer_button'                      => 'Mark as favorite',
    'profile_error_first_name'                              => 'First name must have at least {amount} characters',
    'profile_error_last_name'                               => 'Last name must have at least {amount} characters',
    'profile_error_gender'                                  => 'Select a salutation',
    'profile_error_invalid_email'                           => 'Please use a valid email address',
    'profile_error_phone_number'                            => 'Telephone number must have at least {amount} characters',
    'profile_error_company_name'                            => 'Company name must have at least {amount} characters',
    'profile_error_street_name'                             => 'Street name must have at least {amount} characters',
    'profile_error_house_number'                            => 'House number must have at least {amount} characters',
    'profile_error_street_name_house_number'                => 'Street name & house number must have at least {amount} characters',
    'profile_error_postcode'                                => 'Post code must have at least {amount} characters',
    'profile_error_city'                                    => 'City must have at least {amount} characters',
    'profile_error_state_empty'                             => 'Select a state',
    'profile_error_state'                                   => 'State must have at least {amount} characters',
    'profile_error_email_already_exists'                    => 'The email address is already in use',
    'profile_error_empty_field'                             => 'Field must not be empty',
    'profile_configurations_log_admin_activities_logging'   => 'Yes',
];